package gov.va.med.mhv.sm.api.patient;

import gov.va.med.mhv.sm.api.exception.SMSException;
import gov.va.med.mhv.sm.api.transfer.NotificationStatusTO;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.springframework.stereotype.Service;

@Produces({"application/xml","application/json"})
@Consumes({"application/xml","application/json"})

@Service("preferencesApiService")
public interface PreferencesAPIService {

	//Retrieve Message Notification Preference
	@GET
	@Path("/preferences/notification")
	public Response getNotificationPreference() throws SMSException;

	//Retrieve SM Preference Notification List
	@GET
	@Path("/preferences/notification/list")
	public Response getNotificationPreferenceList() throws SMSException;

	//Execute Message Notification Preference
	@POST
	@Path("/preferences/notification")
	public Response setNotificationPreference(NotificationStatusTO notiTO) throws SMSException;

	//Retrieve Signature Preference
	@GET
	@Path("/preferences/signature")
	public Response getSignatureprefPreference() throws SMSException;

	//Execute Signature Preference
	@POST
	@Path("/preferences/signature")
	public Response setSignaturePreference(NotificationStatusTO notiTO) throws SMSException;
	
	//Retrieve Participation Status
//	@GET
//	@Path("/preferences/participationstatus")
//	public Response getParticipationStatus() throws SMSException;
//	//Retrieve Participation Status
//	
//	@POST
//	@Path("/preferences/participationstatus")
//	public Response setParticipationStatus() throws SMSException;
	
}